//
//CREATING WINDOWS
//
//@sv2agw 2000
#include "agwwin.h"

AGWWinClass::AGWWinClass (char const * className, HINSTANCE hInst, WNDPROC wndProc)
{
_hInstance=hInst;
lstrcpy(_name,className);
_class.lpfnWndProc = wndProc;
SetDefaults();

}
////////
AGWWinClass::AGWWinClass (int resId, HINSTANCE hInst, WNDPROC wndProc)
{
_hInstance=hInst;
 ::LoadString (hInst, resId, _name, MAX_RESSTRING + 1);
_class.lpfnWndProc = wndProc;
SetDefaults();
}
//////////
void AGWWinClass::SetDefaults(void)
{
    // Provide reasonable default values
    _class.cbSize = sizeof (WNDCLASSEX);
    _class.style =0;
    _class.lpszClassName = GetName ();
    _class.hInstance = GetInstance ();
    _class.hIcon = 0;
    _class.hIconSm = 0;
    _class.lpszMenuName = 0;
    _class.cbClsExtra = 0;
    _class.cbWndExtra = 0;
    _class.hbrBackground = reinterpret_cast<HBRUSH> (COLOR_WINDOW + 1);
    _class.hCursor = ::LoadCursor (0, IDC_ARROW);
}
///////////////
void AGWWinClass::SetResIcons (int resId)
{
    _class.hIcon = reinterpret_cast<HICON> (
        ::LoadImage (
            _class.hInstance,
            MAKEINTRESOURCE (resId),
            IMAGE_ICON,
            ::GetSystemMetrics (SM_CXICON),
            ::GetSystemMetrics (SM_CYICON),
            0));
    // Small icon can be loaded from the same resource
    _class.hIconSm = reinterpret_cast<HICON> (
        ::LoadImage (
            _class.hInstance,
            MAKEINTRESOURCE (resId),
            IMAGE_ICON,
            ::GetSystemMetrics (SM_CXSMICON),
            ::GetSystemMetrics (SM_CYSMICON),
            0));

}
///////////////
void AGWWinClass::SetResIcons (LPSTR IconName)
{
    _class.hIcon = reinterpret_cast<HICON> (
        ::LoadImage (
            _class.hInstance,
            IconName,
            IMAGE_ICON,
            ::GetSystemMetrics (SM_CXICON),
            ::GetSystemMetrics (SM_CYICON),
            0));
    // Small icon can be loaded from the same resource
    _class.hIconSm = reinterpret_cast<HICON> (
        ::LoadImage (
            _class.hInstance,
            IconName,
            IMAGE_ICON,
            ::GetSystemMetrics (SM_CXSMICON),
            ::GetSystemMetrics (SM_CYSMICON),
            0));

}
////////////
void AGWWinClass::Register ()
{
    RegisterClassEx (&_class);

}
///////////
HWND AGWWinClass::GetRunningWindow ()
{
    HWND hwnd = ::FindWindow (GetName (), 0);
    if (::IsWindow (hwnd))
    {
        HWND hwndPopup = ::GetLastActivePopup (hwnd);
        if (::IsWindow (hwndPopup))
            hwnd = hwndPopup;
    }
    else
        hwnd = 0;

    return hwnd;
}


////////////////////////////////////////////////////////////
AGWFrameWinClass::AGWFrameWinClass (int resId, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(resId,hInst,wndProc)
{
    SetResIcons (resId);
    _class.lpszMenuName = MAKEINTRESOURCE (resId);
}
///
AGWFrameWinClass::AGWFrameWinClass (LPSTR aName, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(aName,hInst,wndProc)
{
    SetResIcons (aName);
    _class.lpszMenuName =aName;
}

////////////////////////////////////////////////////////////
AGWMDIClass::AGWMDIClass (int resId, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(resId,hInst,wndProc)
{
    SetResIcons (resId);
    _class.lpszMenuName = MAKEINTRESOURCE (resId);
    _class.style=CS_HREDRAW | CS_VREDRAW;
}
///
AGWMDIClass::AGWMDIClass (LPSTR aName, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(aName,hInst,wndProc)
{
    SetResIcons (aName);
    _class.lpszMenuName =aName;
    _class.style=CS_HREDRAW | CS_VREDRAW;
}
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
AGWChildClass::AGWChildClass (int resId, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(resId,hInst,wndProc)
{
    SetResIcons (resId);
    _class.lpszMenuName = MAKEINTRESOURCE (resId);
}
///
AGWChildClass::AGWChildClass (LPSTR aName, HINSTANCE hInst, WNDPROC wndProc)
                   :AGWWinClass(aName,hInst,wndProc)
{
    SetResIcons (aName);
    _class.lpszMenuName =aName;
}
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

AGWFrameWindow::AGWFrameWindow (AGWFrameWinClass & winClass, char const * caption)
  : _hwnd (0),
    _class (winClass),
    _exStyle (0),       // extended window style
    _windowName (0),    // pointer to window name
    _style (WS_OVERLAPPED), // window style
    _x (CW_USEDEFAULT), // horizontal position of window
    _y (0),             // vertical position of window
    _width (CW_USEDEFAULT), // window width
    _height (0),        // window height
    _hWndParent (0),    // handle to parent or owner window
    _hMenu (0),         // handle to menu, or child-window identifier
    _data (0)           // pointer to window-creation data
{
   _style = WS_OVERLAPPEDWINDOW;
    _windowName = caption;

}

void AGWFrameWindow::Create ()
{
    _hwnd = ::CreateWindowEx (
        _exStyle,
        _class.GetName (),
        _windowName,
        _style,
        _x,
        _y,
        _width,
        _height,
        _hWndParent,
        _hMenu,
        _class.GetInstance (),
        _data);

//    if (_hwnd == 0)
//        throw WinException ("Internal error: Window Creation Failed.");
}

void AGWFrameWindow::Show (int nCmdShow)
{
    ::ShowWindow (_hwnd, nCmdShow);
    ::UpdateWindow (_hwnd);
}

/////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

AGWMDI::AGWMDI (AGWMDIClass & winClass, char const * caption)
  : _hwnd (0),
    _class (winClass),
    _exStyle (0),       // extended window style
    _windowName (0),    // pointer to window name
    _style (0), // window style
    _x (CW_USEDEFAULT), // horizontal position of window
    _y (0),             // vertical position of window
    _width (CW_USEDEFAULT), // window width
    _height (0),        // window height
    _hWndParent (0),    // handle to parent or owner window
    _hMenu (0),         // handle to menu, or child-window identifier
    _data (0)           // pointer to window-creation data
{
   _style = WS_OVERLAPPEDWINDOW;
    _windowName = caption;

}

void AGWMDI::Create ()
{
    _hwnd = ::CreateWindowEx (
        _exStyle,
        _class.GetName (),
        _windowName,
        _style,
        _x,
        _y,
        _width,
        _height,
        _hWndParent,
        _hMenu,
        _class.GetInstance (),
        _data);

//    if (_hwnd == 0)
//        throw WinException ("Internal error: Window Creation Failed.");
}

void AGWMDI::Show (int nCmdShow)
{
    ::ShowWindow (_hwnd, nCmdShow);
    ::UpdateWindow (_hwnd);
}

/////////////////////////////////////////////////////////////////////

