//sv2agw socket thread
//@sv2agw 2000
//

/*
Here is the interesting stuff. It is a class (object) of a winsock ver 2
stream tcpip socket.
The code is full of remarks just to see how to handle.
The socket is event driven. When something happens we notified with an event.


*/

#include "monitorsocket.h"
#include "constant.h"

extern char IniFile[];


MonitorSocket::MonitorSocket(MonitorDsktp *AParent)
                 :ActiveObject()
{
Parent=AParent;
flag=false;//flag for data received from applications
Ports.Num=0;//RadioPorts structure that is filled when a 'G' command respond comes
FlagCreateTermWin=FALSE;
int xxx=GetPrivateProfileInt("PACKET","OEMANSI",1,IniFile);//To convert chars to
if (xxx==0) OEMANSI=FALSE; else OEMANSI=TRUE;              //MSDOS CHAR SET
MonitorKind=GetPrivateProfileInt("PACKET","MONITOR",4,IniFile);//What kind of frames                                                          //to display
}
//*****************************************************************************
MonitorSocket::~MonitorSocket()
{
struct _OUTPUT_REQUEST *OutReq;
if (!_isDying) Kill();
closesocket(AGWPESocket);//close our socket
WSACloseEvent(SockEvent);//close the socket event object
// Remove from queu frames to tx
for (;;)
{
     OutReq = (struct _OUTPUT_REQUEST*)TxQueue.getq();
     if (!OutReq) break;
    CloseHandle(OutReq->Overlapped->hEvent);
    delete(OutReq->Buffer.buf);
    delete(OutReq->Overlapped);
    delete(OutReq);

}
//remove and close events for pending write operations
for (int x=1;x<NumEvents;x++)
{
      OutReq = OutReqArray[x];
        if (OutReq==NULL) continue;
         CloseHandle(OutReq->Overlapped->hEvent);
        delete(OutReq->Buffer.buf);
        delete(OutReq->Overlapped);
        delete(OutReq);
}
}
//*****************************************************************************
//Is called from monitordsktp to start the socket
void MonitorSocket::Start(void)
{
OutputDebugString("MONITORSOCKET START");
u_short AGWPEPort;
u_long   InetAddr;
char HostAddr[40];
struct hostent *host;
struct sockaddr_in SockAddrInet;

//first get the port to access agwpe
AGWPEPort=(u_short)GetPrivateProfileInt("PACKET","SOCKSPORT",8000,IniFile);

//and write it back to ini file in case there is no entry
wsprintf(HostAddr,"%d",AGWPEPort);
WritePrivateProfileString("Packet","SOCKSPORT",HostAddr,IniFile);

//get now the tcpip address of the machine where agwpe runs
GetPrivateProfileString("PACKET","SOCKSADR","127.0.0.1",HostAddr,40,IniFile);

//and write it back to ini in case there is no entry
WritePrivateProfileString("Packet","SOCKSADR",HostAddr,IniFile);
// if there are no entries for socket port/sddress we use the default values
// localhost(127.0.0.1) and port 8000.


//create the address suitable for winsock
InetAddr = inet_addr(HostAddr);
if (InetAddr == INADDR_NONE)// this means that address is a name like www.agw.org
	{
    host = gethostbyname(HostAddr);// in case that we need a dns to get the address
     if (host) {
                    InetAddr = *((u_long *)host->h_addr_list[0]);
                }
   }

//create a sockaddress structure
SockAddrInet.sin_family = AF_INET;
SockAddrInet.sin_port = htons(AGWPEPort);
SockAddrInet.sin_addr.S_un.S_addr = InetAddr;

//Create the socket
AGWPESocket=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
if (AGWPESocket==INVALID_SOCKET) OutputDebugString("ERROR SOCKET1");//we must abort

//create an event for socket notifications
SockEvent=CreateEvent(NULL,FALSE,FALSE,NULL);//create event
if (!SockEvent) OutputDebugString("no event create");//here we must abort the program
//select the event to be notified
//we need only connect,close and read
if (WSAEventSelect(AGWPESocket,SockEvent,FD_CONNECT|FD_READ|FD_CLOSE)==SOCKET_ERROR) OutputDebugString("eventselect  SOCKET ERROr");

//NOW connect the socket
int Err=connect(AGWPESocket,(struct sockaddr*)&SockAddrInet,sizeof(SockAddrInet));
if (Err==SOCKET_ERROR)
   if (WSAGetLastError()!=WSAEWOULDBLOCK)// the socket will notify us later
   {
   //it is  a fatal error
	MessageBox(NULL,"Error Connecting to Packet Engine!","AGWMONITOR",MB_OK);
	closesocket(AGWPESocket);
   WSACloseEvent(SockEvent);
   }

//we need them to check which operation signal us
NumEvents=1;
EventArray[0]=SockEvent;
Resume ();//start the thread running calling the loop() function

}
//*****************************************************************************
//this is the thread loop called when we call the resume()
void MonitorSocket::Loop(void)
{
WSANETWORKEVENTS NetworkEvents;    // tells us what events happened
int resultEvent;
DWORD Result;
SetThreadPriority( _thread._handle,THREAD_PRIORITY_IDLE	);//make our thread low priority

for (;;)
{
SleepEx(10,TRUE);
 if (_isDying)    return;
 //wait for the socket events for ever
 //the function returns if any event is signalled
 Result=WSAWaitForMultipleEvents(NumEvents,EventArray,FALSE,WSA_INFINITE,FALSE);
 if (_isDying)    return;   //our program must terminate
switch (Result)
{
  case WSA_WAIT_TIMEOUT 	:OutputDebugString("WSA_WAIT_TIMEOUT");continue;
  case WSANOTINITIALISED	:
  case WSAENETDOWN	:
  case WSAEINPROGRESS	:
  case WSA_NOT_ENOUGH_MEMORY	:
  case WSA_INVALID_HANDLE	:
  case WSA_INVALID_PARAMETER	:
  case WAIT_IO_COMPLETION 	:
  case WSA_WAIT_FAILED:     OutputDebugString("Error Socket");
                           GoToIdleStateOut();//we need to close the program
                                              //an unexpected error occured
							      continue;
 case WSA_WAIT_EVENT_0://it is an event from our socket must be
                       // either connect or received data or close socket
                       //so now check what kind event is
							   resultEvent = WSAEnumNetworkEvents(AGWPESocket,SockEvent,&NetworkEvents);
						     if (resultEvent == SOCKET_ERROR)
						    	{
                           GoToIdleState();//unexpected error abort
							      break;//break loop
						      }

                       //it is a read event
						     if (NetworkEvents.lNetworkEvents & FD_READ)
					       {
                            //check if there is any error
					          if (NetworkEvents.iErrorCode[FD_READ_BIT] != 0)
					          	{
                              GoToIdleState();//yes error abort
						            break;
					            }
                           else {// ok everything ok go read the data
                                 ReceivedData();
                                 continue;
                                 }
					        }//end if fdread event
                          //it is a connect event check it
						     if (NetworkEvents.lNetworkEvents & FD_CONNECT)
					       {
                            //may our attemt to connect failed
					          if (NetworkEvents.iErrorCode[FD_CONNECT_BIT] !=0)
					          	{
                              GoToIdleState();//abort, the connection failed
						            break;
					            }
                           else {//ok we are connected
                                 //ask agwpe for radioport info
                                 struct HEADERTCP Hed;
	    									Hed.port=0;
   	 									Hed.DataKind=MAKELONG('G',0);
    	 									lstrcpy(Hed.callfrom,MyCall);
    	 									lstrcpy(Hed.callto,MyCall);
    	 									Hed.size=0;
       									PutDataTxQue((char *)&Hed,sizeof(Hed));
                                 continue;
                                 }
					        }//end if fdread event
                       //a close event. Our socket closed from agwpe
				        if (NetworkEvents.lNetworkEvents & FD_CLOSE)
             			{
                     GoToIdleState();//abort
                     break;
                     }
                     break;
     //this must be a write event
     default:
           OutputDebugString("lOOP Switch Result->Default");
           //ok go and send if there are other data
            WriteEventOccured(Result);
            break;

 } //end wait_object_0

}   //end for
OutputDebugString("THREAD LOOP exit");
}
//*****************************************************************************
void MonitorSocket::FlushThread ()
{
//to close and exit the thread ,signal the socket event so the wsawait function will return
//then the isDying will stop the loop
SetEvent(SockEvent);
}
//*****************************************************************************
void MonitorSocket::GoToIdleState(void)
{
OutputDebugString("GOTOIDLESTATE");
Kill();//kill the thread
closesocket(AGWPESocket);
CloseHandle(SockEvent);
// fire a dialog disconnect from agwpe
MessageBox(NULL,"Disconnected from Packet Engine!","AGWMONITOR",MB_OK|MB_ICONWARNING);
}
//*****************************************************************************
void MonitorSocket::GoToIdleStateOut(void)
{
OutputDebugString("GOTOIDLESTATEOUT");
Kill();
closesocket(AGWPESocket);
WSACloseEvent(SockEvent);
// fire a dialog disconnect from agwpe
MessageBox(NULL,"Disconnected from Packet Engine!","AGWMONITOR",MB_OK|MB_ICONWARNING);
}
//*****************************************************************************
//this function sends our data to agwpe
//with overlapped operations
//
void MonitorSocket::PutDataTxQue(unsigned char *szDataToSend, int nCharsToSend)
{
OutputDebugString("PUTDATATXQUE");
struct _OUTPUT_REQUEST *OutReq;
//allocate memory
OutReq=new struct  _OUTPUT_REQUEST;
OutReq->Buffer.buf=new unsigned char [ nCharsToSend+5];
OutReq->Overlapped = new struct WSAOVERLAPPED;

//fill fields
MoveMemory(OutReq->Buffer.buf,szDataToSend,  nCharsToSend);
OutReq->Buffer.len=nCharsToSend;
if (!OutReq->Overlapped)    OutputDebugString("OXI OVERLAPPED");
OutReq->Overlapped->hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);//create a new event object
                                                              //for this write operation.
                                                              //if the data cannot be sent now
                                                              //socket will notify us later using this
                                                              //event object


//for check only
DWORD           BytesSent=0;     // needed in WSASend
//send the data as overlapped
DWORD result=WSASend(AGWPESocket,&OutReq->Buffer,1,&BytesSent,0,OutReq->Overlapped,NULL);
if (result == SOCKET_ERROR)
	{
    int Result = WSAGetLastError();
    switch(Result)
                  {
                  case  WSA_IO_PENDING://the data will be sent later
                  OutputDebugString("WSA_IO_PENDING");
	                                NumEvents++;
   							           EventArray[NumEvents - 1] =OutReq->Overlapped->hEvent;
                                   OutReqArray[NumEvents - 1] = OutReq;
                                   return;
                      case WSAEWOULDBLOCK://the socket is full of data waiting for tx
                                          //the socket cannot accept more data
                                          //so we put them in our queu
                                          //we will remove them from queu later when
                                          //the socket will be able to handle more data
                                          //This will happen when we receive an event
                                          //notify from other send operations that are
                                          //pending
                                          TxQueue.putq((struct stqcell *)OutReq);
                                          return;//no data send no need to wait
                      default://fatal or unknown error. Terminate
										GoToIdleState();
                              return;
                     };//end switch
    		}//end if result
else //result !=ERROR
{
//the send operation is completed immediately
//we need to delete and free the memory for this send operation
OutputDebugString("DIRECT WRITE");
CloseHandle(OutReq->Overlapped->hEvent);
delete(OutReq->Buffer.buf);
delete(OutReq->Overlapped);
delete(OutReq);
}

}

//*****************************************************************************

void MonitorSocket::ReceivedData(void)
{

/*
This function is called when the callback function is notified of
available data.
*/

int nError;
char szData[3001];
int  nLength;
int HowManyCharsWait;
int HowManyReadSoFar=0;
struct HEADERTCP Hed;
char HeardListStr[100];
//check how many characters are waiting in the socket for reading
HowManyCharsWait=recv(AGWPESocket,szData,3000,MSG_PEEK);
if (HowManyCharsWait== SOCKET_ERROR) {OutputDebugString("SOCKRECV ERROR");GoToIdleState();return;}
for (;;)
{
if (!flag)//this means that we must read a header first
{
 //if the characters waiting are less than a header dont read them.
 //we read them later when more data arrive
 if ((HowManyCharsWait-HowManyReadSoFar)<sizeof(Header)) {flag=false;return;}
nLength=sizeof(Header);
nError = recv(AGWPESocket,szData, nLength,0);//read only the   header
if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
HowManyReadSoFar+=nLength;
CopyMemory(&Header,szData,sizeof(Header));
flag=false;
}

	switch((LOWORD(Header.DataKind)))
	{
	case 'U'://MONITOR DATA UNPROTO
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
                                         //the data are not complete
                                         //leave them into the socket
                                         //we will read them later when more data
                                         //available.
                                         //We mark the flag so next time we call this
                                         //function we shall not read a header, since we already
                                         //read it.
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
	       if ((MonitorKind & MU)==MU)
          {
			  if (OEMANSI) 	OemToChar(szData,szData);

			Parent->Terminal->InsertData(Parent->GetWindow(),szData,Header.size);
			 }
             flag=false;
	 			 continue;

	case 'T'://TXDATA MONITOR (our frames)
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
			 if ((MonitorKind & MTX)==MTX)
			if (OEMANSI) 	OemToChar(szData,szData);
			Parent->Terminal->InsertData(Parent->GetWindow(),szData,Header.size);
             flag=false;
	 			 continue;
	case 'S'://MONITOR HEADER
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}

			 if ((MonitorKind & MS)==MS)
			if (OEMANSI) 	OemToChar(szData,szData);
			Parent->Terminal->InsertData(Parent->GetWindow(),szData,Header.size);
             flag=false;
	 			 continue;
	case 'I'://MONITOR  HEADER+DATA CONNECT OTHER STATIONS
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}

			 if ((MonitorKind & MI)==MI)
			if (OEMANSI) 	OemToChar(szData,szData);
			Parent->Terminal->InsertData(Parent->GetWindow(),szData,Header.size);
             flag=false;
	 			 continue;
	case 'H'://MHeardList
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
          if (Header.callfrom[0]==' ') break;
	      wsprintf(HeardListStr,"Port%d>%s\r",Header.port+1,szData);
			Parent->Terminal->InsertData(Parent->GetWindow(),HeardListStr,lstrlen(HeardListStr)+1);
             flag=false;
	 			 continue;
   case 'G'://PORT LIST
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
            GetPorts(szData);
       		if (!FlagCreateTermWin) {StartAfterConnect();FlagCreateTermWin=TRUE;}
            //Tell now AGWPE to start sending monitoring frames
	    Hed.port=0;
   	 Hed.DataKind=MAKELONG('m',0);
    	 lstrcpy(Hed.callfrom,MyCall);
    	 lstrcpy(Hed.callto,MyCall);
    	 Hed.size=0;
       PutDataTxQue((char *)&Hed,sizeof(Hed));
             flag=false;
	 			 continue;

	default://Important *****
           //we must read any frame arrived.
           //otherwise the socket will block
           //We can read the frame and discard it
         if ((HowManyCharsWait-HowManyReadSoFar)<Header.size) {flag=true;return;}
			 nError = recv(AGWPESocket,szData, Header.size,0);//read the rest
          HowManyReadSoFar+=Header.size;
			 if (nError == SOCKET_ERROR) {GoToIdleState();return ;}
			if (OEMANSI) 	OemToChar(szData,szData);
	      Parent->Terminal->InsertData(Parent->GetWindow(),szData,Header.size);
          wsprintf(szData,"%d=%c",Header.port,Header.DataKind);
	      Parent->Terminal->InsertData(Parent->GetWindow(),szData,lstrlen(szData));
             flag=false;
	 			 continue;

        }//END SWITCH
   flag=false;
  }//end for read loop
}
//*****************************************************************************
//parse the radioport info
void MonitorSocket::GetPorts(char *Str)
{
char *token;
token=strtok(Str,";");
Ports.Num=atoi(token);
for (int x=0;x<Ports.Num;x++)
  {
  token=strtok(NULL,";");
  if (token==NULL) return;
  strcpy(Ports.Port[x],token);
  }
}
//***********************************************************
//we are conneted to agwpe and we received the radioport info
//so create the terminal window(s) or other initialization
//
void MonitorSocket::StartAfterConnect(void)
{

}
//*****************************************************************************
//Here a pending write operation is signalled as finished
//we must delete and free the memory for this write operation objects
//and we must send any other data that were refused by the socket
//
void MonitorSocket::WriteEventOccured(DWORD WaitStatus)
{
OutputDebugString("WRITEEVENTOCCURED");
struct _OUTPUT_REQUEST *OutReq;
int Count;
if (WaitStatus==0) return;
    if ((WaitStatus >= WSA_WAIT_EVENT_0) && (WaitStatus <= (WSA_WAIT_EVENT_0  + NumEvents - 1)))
        {

        // Free the data buffer, the overlapped structure, the output
        // request itself, and the event
        OutReq = OutReqArray[WaitStatus - WSA_WAIT_EVENT_0];
        if (OutReq==NULL) return;
         CloseHandle(OutReq->Overlapped->hEvent);
        delete(OutReq->Buffer.buf);
        delete(OutReq->Overlapped);
        delete(OutReq);


        // Update all our event and output request arrays to
        // reflect that the overlapped send has completed.
        NumEvents--;
        for (Count = (WaitStatus - WSA_WAIT_EVENT_0);Count < NumEvents;Count++)
        {
            EventArray[Count] = EventArray[Count + 1];
            OutReqArray[Count] = OutReqArray[Count + 1];
        }
    if (TxQueue.IsData())//there are data waiting for tx in our Queu (refused by the socket)
    {
    LPWSABUF        Buffers;       // points to an array of WSABUFs
     DWORD           BytesSent;     // needed in WSASend
     //get the data from the queu but dont remove them from the que
     //just in case the data will not accepted again by the socket
     //
     OutReq = (struct _OUTPUT_REQUEST*)TxQueue.getCheckq();
     Buffers = &(OutReq->Buffer);
		int result=WSASend(AGWPESocket,Buffers,1,&BytesSent,0,OutReq->Overlapped,NULL);
		if (result == SOCKET_ERROR)
     		{
        int Result = WSAGetLastError();
        switch(Result)
                      {
                      case  WSA_IO_PENDING:
	                                NumEvents++;
   							           EventArray[NumEvents - 1] =OutReq->Overlapped->hEvent;
                                   OutReqArray[NumEvents - 1] = OutReq;
                                   //remove the data from the que now that are accepted
                                   //
                                   TxQueue.getq();
                                   break;

                      case WSAEWOULDBLOCK://refused again
                                          //just return since we havent removed the data
                                          return;
                      default://fatal error
										GoToIdleState();
                              return;
                     };
    		}//end if socket_error
         else
         {
          //impossible but just in case*****
			//the send operation is completed immediately
			//we need to delete and free the memory for this send operation
			OutputDebugString("DIRECT WRITE");
         TxQueue.getq();//remove from queue
			CloseHandle(OutReq->Overlapped->hEvent);
			delete(OutReq->Buffer.buf);
			delete(OutReq->Overlapped);
			delete(OutReq);
         }
     }//if isdata

}//end for data
}

//*****************************************************************************


