#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Fresnel Zone Boundary Calculator, fresnel.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin";
select STDOUT;
$| = 1;

sub System {
if ((0xffff & system $args) != 0 ) {
  print STDERR "error: $!\n";
  exit 1;
 }
}

my $pic = "pics/fresnel.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

my $nth = $FORM{'nth'};

my $a_dis = $FORM{'a_dis'};
my $a_dis_val = $FORM{'a_dis_val'};

my $b_dis = $FORM{'b_dis'};
my $b_dis_val = $FORM{'b_dis_val'};

# Clean up user input data
#
$frq =~ tr/0-9.//csd;

if (!$frq) {
  $frq_mhz = 2450; $frq_val = "MHz"; # 2450 MHz
}

if ($frq_val eq "GHz") {
  $frq_mhz = $frq * 1000; # GHz to MHz
} 
else {
  $frq_mhz = $frq;
}

$a_dis =~ tr/0-9.//csd;

if (!$a_dis) {
  $a_dis = 2000; $a_dis_val = "meters"; # 2000 meters
}

$b_dis =~ tr/0-9.//csd;

if (!$b_dis) {
  $b_dis = 2000; $b_dis_val = "meters"; # 2000 meters
}

# Site A distance in meters
#
if ($a_dis_val eq "kilometers") {
  $a_dis = $a_dis * 1000; # km to m
}
elsif ($a_dis_val eq "miles") {
  $a_dis = $a_dis * 1609.344; # mi to m
}
elsif ($a_dis_val eq "feet") {
  $a_dis = $a_dis * 0.3048; # ft to m
}

# Site B distance in meters
#
if ($b_dis_val eq "kilometers") {
  $b_dis = $b_dis * 1000; # km to m
}
elsif ($b_dis_val eq "miles") {
  $b_dis = $b_dis * 1609.344; # mi to m
}
elsif ($b_dis_val eq "feet") {
  $b_dis = $b_dis * 0.3048; # ft to m
}

# Start calculations
#
$fresnel_06 = 17.31 * (sqrt ((0.6 * $a_dis * $b_dis) / ($frq_mhz * ($a_dis + $b_dis))));
$fresnel = 17.31 * (sqrt (($nth * $a_dis * $b_dis) / ($frq_mhz * ($a_dis + $b_dis))));

# Make all pretty
#
$fresnel_06_ft = sprintf "%.3f", $fresnel_06 * 3.2808399;
$fresnel_06 = sprintf "%.3f", $fresnel_06;

$fresnel_ft = sprintf "%.3f", $fresnel * 3.2808399;
$fresnel = sprintf "%.3f", $fresnel;

$frq_mhz = sprintf "%.3f", $frq_mhz;

$a_dis_km = sprintf "%.3f", $a_dis * 0.001;
$a_dis_mi = sprintf "%.3f", $a_dis / 1609.344;

$b_dis_km = sprintf "%.3f", $b_dis * 0.001;
$b_dis_mi = sprintf "%.3f", $b_dis / 1609.344;

$total_path_km = sprintf "%.3f", $a_dis_km + $b_dis_km;
$total_path_mi = sprintf "%.3f", $a_dis_mi + $b_dis_mi;

$date = scalar gmtime;

if ($nth == 0.3 || $nth == 0.4 || $nth == 0.5 || $nth == 0.7 || $nth == 0.8 || $nth == 0.9) {
 $x = "";
}
elsif ($nth == 1) {
  $x = "st";
}
elsif ($nth == 2) {
  $x = "nd";
}
elsif ($nth == 3) {
  $x = "rd";
}
else {
  $x = "th";
}

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Fresnel Zone Boundary Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Fresnel Zone Boundary Calculator Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[fresnel zone]"></center>

<hr noshade>
<pre>
$b 0.6 Fresnel zone boundary : $e$fresnel_06$b meters ($e$fresnel_06_ft$b feet) $e
$b $nth$x Fresnel zone boundary : $e$fresnel$b meters ($e$fresnel_ft$b feet) $e
</pre>

<pre>
      $p Operating frequency : $e$frq_mhz$p MHz $e
     $p Distance from site A : $e$a_dis_km$p kilometers ($e$a_dis_mi$p miles) $e
     $p Distance from site B : $e$b_dis_km$p kilometers ($e$b_dis_mi$p miles) $e
 $p Total link path distance : $e$total_path_km$p kilometers ($e$total_path_mi$p miles) $e
</pre>

<hr noshade size="5">

<blockquote>
<p>The 0.6 Fresnel zone needs to be clear in direct sequence spread spectrum systems (DSSS) and the 0.8 Fresnel zone clear for frequency hopping systems (FHSS).</p>
</blockquote>
EOF

$Ftmp = "tmp/test$$";
$Ftmp1 = "tmp/testA$$";
$Gtmp = "tmp/gnuplot$$";
$Gout = "tmp/fresnel$$.jpg";
$step = ($total_path_km * 1000) / 50; # meters

open F1, ">$Ftmp" || die "Can't open $Ftmp: $!";
open F2, ">$Ftmp1" || die "Can't open $Ftmp1: $!";
 print F1  "0.00\t\t0.00\n";
 print F2 "0.00\t\t0.00\n";
 for ($pl = $step; $pl < ($total_path_km * 1000); $pl = $pl + $step) {
   $fn = 17.31 * sqrt ((0.6 * ($pl * (($total_path_km * 1000) - $pl))) / ($frq_mhz * ($total_path_km * 1000)));
   $fnn = 17.31 * sqrt (($nth * ($pl * (($total_path_km * 1000) - $pl))) / ($frq_mhz * ($total_path_km * 1000)));
   printf F1 "%.2f\t\t%.2f\n", $pl / 1000, $fn;
   printf F2 "%.2f\t\t%.2f\n", $pl / 1000, $fnn;
 }
 print F1 "$total_path_km\t\t0.00\n";
 print F2 "$total_path_km\t\t0.00\n";
close F1;
close F2;

$half = ($total_path_km / 2) * 1000;;
$dist = $total_path_km * 1000;
$yrange = sprintf "%.f", (17.31 * sqrt (($nth * $half * ($dist - $half)) / ($frq_mhz * $dist))) + 5;

open F, ">$Gtmp" || die "Can't open $Gtmp: $!";
  print F "set yrange [$yrange:0]\n";
  print F "set xrange [0:$total_path_km]\n";
  print F "set title \"Fresnel Zone Clearance for $frq_mhz MHz\"\n";
  print F "set ylabel \"Fresnel Radius - Meters\\n\\n0.6 Midpoint: $fresnel_06    $nth$x Midpoint: $fresnel\"\n";
  print F "set xlabel \"Path Distance - Kilometers\\n\\nTotal Path Distance: $total_path_km\"\n";
  print F "set grid\n";
  print F "set samples 200\n";
  print F "set clip\n";
  print F "set mytics\n";
  print F "set mxtics\n";
  print F "set ticscale 2 1\n";
  print F "set key below bottom right\n";
  print F "set term jpeg interlace large\n";
  print F "set output \"$Gout\"\n";
  print F "plot \"$Ftmp\" smooth bezier title '0.6 Fresnel' lw 4,".
          "\"$Ftmp1\" smooth bezier title '#$nth Fresnel' lw 4\n";
close F;

&System($args = "gnuplot $Gtmp");

unlink $Ftmp, $Ftmp1, $Gtmp;

print "<center><img src=\"$Gout\"></center>";
print "<font size=\"-1\">Calculated on $date GMT</font></body></html>";
