#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Omnidirectional Antenna Beamwidth Analysis, omni.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/omni.png";
my $form = "./omni.cgi";

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Omnidirectional Antenna Beamwidth Analysis</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<font face="Verdana, Arial, Helvetica">
<h2>Omnidirectional Antenna Beamwidth Analysis</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<center><img src="$pic" alt="[omni]"></center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td align="left"><b>Enter the antenna's 3 dB vertical beamwidth (&lt;120&deg;)</b></td>
<td align="right"><input type="text" name="vb" size="5" value=""></td>
<td align="right">degrees</td>
</tr>

<tr>
<td align="left"><b>Enter the antenna's downtilt angle (&lt;90&deg;)</b></td>
<td align="right"><input type="text" name="dt" size="5" value="0"></td>
<td align="right">degrees</td>
</tr>

<tr>
<td align="left"><b>Enter the effective Earth radius (K factor)</b></td>
<td align="right"><input type="text" name="k" size="5" value="1.33"></td>
</tr>

<tr>
<td align="left"><b>Enter the antenna's height (AGL)</b></td>
<td align="right"><input type="text" name="ht" size="5" value=""></td>
<td align="right"><select name="ht_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<p><b>AGL</b>&nbsp;&nbsp;Above Ground Level.&nbsp;&nbsp;Height above common ground to the the mid-point of the radiating antenna.</p>

<p>The K factor accounts for refraction of radio waves close to the surface of the earth.&nbsp;&nbsp;For antenna towers less than a couple of thousand feet above the surface, a K factor of 1.33 is usually adequate for most line-of-sight calculations over average terrain.</p>

<b><u>Typical Values of K</u></b>

<font face="">
<pre>
                                        Summer  Winter

Dry mountains (above 1500 meters)       1.20    1.20
Mountains (to 1500 meters)              1.25    1.25
Midwest and Northeast                   1.50    1.30
South and West Coast                    1.55    1.35
Southern Coast                          1.60    1.50
</pre>
</font>
</blockquote>

</body>
</html>
EOF
