#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Return Loss Calculator, rtrn_loss.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

my $pic = "pics/swr.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $fwdpwr = $FORM{'fwdpwr'};
my $revpwr = $FORM{'revpwr'};

my $fwdpwr_val = $FORM{'fwdpwr_val'};
my $revpwr_val = $FORM{'revpwr_val'};

my $inputswr = $FORM{'inputswr'};

# Clean up user input data
#
$fwdpwr =~ tr/0-9.//csd;
$fwdpwr_val =~ tr/a-zA-Z//csd;

if (!$fwdpwr) {
  $fwdpwr = 50; $fwdpwr_val = "Watts"; # 50 watts
}

$revpwr =~ tr/0-9.//csd;
$revpwr_val =~ tr/a-zA-Z//csd;

if (!$revpwr) {
  $revpwr = 2; $revpwr_val = "Watts"; # 2 watts
}

$inputswr =~ tr/0-9.//csd;

# Start calculations
#
if ($fwdpwr_val eq "milliwatts") {
  $fwdpwr = $fwdpwr / 1000; # mw to w
}
elsif ($fwdpwr_val eq "dBm") {
  $fwdpwr = (10 ** ($fwdpwr / 10)) / 1000; # dBm to w
}

if ($revpwr_val eq "milliwatts") {
  $revpwr = $revpwr / 1000; # mw to w
  $finalpwr = $fwdpwr - $revpwr;
}
elsif ($revpwr_val eq "dBm") {
  $revpwr = (10 ** ($revpwr / 10)) / 1000;
  $finalpwr = $fwdpwr - $revpwr;
}
elsif ($revpwr_val eq "dB") {
  $finalpwr = $fwdpwr / (10 ** ($revpwr / 10));
  $revpwr = $fwdpwr - $finalpwr;
}
elsif ($revpwr_val eq "Watts") {
  $finalpwr = $fwdpwr - $revpwr;
}

# Percent loss
$percent = 100 / ($fwdpwr / $revpwr);
# Power Loss - dB
$pwrlossdb = (log10 ($fwdpwr / $finalpwr)) * 10;
# Final Power - dBm
$finalpwrdbm = (log10 ($finalpwr / 0.001)) * 10;
# Final Power - dB
$finalpwrdb = (log10 $finalpwr) * 10;
# Forward Power - dBm
$fwdpwrdbm = (log10 ($fwdpwr / 0.001)) * 10;
# Forward Power - dB
$fwdpwrdb = (log10 $fwdpwr) * 10;
# Reverse Power - dBm
$revpwrdbm = (log10 ($revpwr / 0.001)) * 10;
# Reverse Power - dB
$revpwrdb = (log10 $revpwr) * 10;
# Standing Wave Ration (SWR)
$a = sqrt ($revpwr / $fwdpwr);
$swr = (1 + $a) / (1 - $a);
# reflection coefficient and return loss
$p = ($swr - 1) / ($swr + 1);
$rtrnlossdb = -8.68589 * log($p);
$refco = $p;
$transfer = 100 - $percent;

if ($inputswr) {
  $swr = $inputswr;
  $fwdpwr = $fwdpwrdbm = $fwdpwrdb = $revpwr = $revpwrdbm = $revpwrdb = 0;
  $finalpwr = $finalpwrdbm = $finalpwrdb = $percent = $transfer = 0;

  if ($swr <= 1) {
    $swr = "1.01";
  }

  $p = ($swr - 1) / ($swr + 1);
  $refco = $p;
  $rtrnlossdb = -8.68589 * log($p);
  $pwrlossdb = -4.34295 * log(1 - ($p ** 2));
}

# Make all pretty
#
$percent = sprintf "%.3f", $percent;
$transfer = sprintf "%.3f", $transfer;

$fwdpwr = sprintf "%.6f", $fwdpwr;
$fwdpwrdbm = sprintf "%.6f", $fwdpwrdbm;
$fwdpwrdb = sprintf "%.6f", $fwdpwrdb;

$revpwr = sprintf "%.6f", $revpwr;
$revpwrdbm = sprintf "%.6f", $revpwrdbm;
$revpwrdb = sprintf "%.6f", $revpwrdb;

$finalpwr = sprintf "%.6f", $finalpwr;
$finalpwrdbm = sprintf "%.6f", $finalpwrdbm;
$finalpwrdb = sprintf "%.6f", $finalpwrdb;

$pwrlossdb = sprintf "%.6f", $pwrlossdb;
$rtrnlossdb = sprintf "%.6f", $rtrnlossdb;

$refco = sprintf "%.3f", $refco;
$swr = sprintf "%.3f", $swr;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Return Loss Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Return Loss Calculator Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[swr]"></center>

<hr noshade>
<pre>
     $b Forward power : $e$fwdpwr$b Watts ($e$fwdpwrdbm$b dBm or $e$fwdpwrdb$b dBW) $e
     $b Reverse power : $e$revpwr$b Watts ($e$revpwrdbm$b dBm or $e$revpwrdb$b dBW) $e
$b Final power output : $e$finalpwr$b Watts ($e$finalpwrdbm$b dBm or $e$finalpwrdb$b dBW) $e
<br>
                   $p Return loss : $e$rtrnlossdb$p dB $e
  	         $p Mismatch loss : $e$pwrlossdb$p dB $e
               $p Reflected power : $e$percent$p % $e
             $p Transferred power : $e$transfer$p % $e
$p Voltage reflection coefficient : $e$refco
                   $p Maximum SWR : $e$swr$p to$e 1
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
