#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Antenna Tilt Calculator, tilt.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/tilt.png";
my $form = "./tilt.cgi";
my $k = 1.33; # K factor, Earth radius factor

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Antenna Tilt Calculator</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<font face="Verdana, Arial, Helvetica">
<center>
<h2>Antenna Tilt Calculator</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<center><img src="$pic" alt="[tilt]"></center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td align="left"><b>Height of antenna A (AGL)</b></td>
<td align="right"><input type="text" name="ht_a" size="5" value=""></td>
<td align="right"><select name="ht_a_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Ground elevation at antenna site A (AMSL)</b></td>
<td align="right"><input type="text" name="elv_a" size="5" value=""></td>
<td align="right"><select name="elv_a_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Height of antenna B (AGL)</b></td>
<td align="right"><input type="text" name="ht_b" size="5" value=""></td>
<td align="right"><select name="ht_b_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Ground elevation at antenna site B (AMSL)</b></td>
<td align="right"><input type="text" name="elv_b" size="5" value=""></td>
<td align="right"><select name="elv_b_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the total path distance</b></td>
<td align="right"><input type="text" name="dis" size="5" value=""></td>
<td align="right"><select name="dis_val">
<option selected>kilometers</option>
<option>meters</option>
<option>miles</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the effective Earth radius (K factor)</b></td>
<td align="right"><input type="text" name="k" size="5" value="$k"></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<p><b>AGL</b>&nbsp;&nbsp;Above Ground Level.&nbsp;&nbsp;Height above common ground to the the mid-point of the radiating antenna.</p>

<p><b>AMSL</b>&nbsp;&nbsp;Above Mean Sea Level.&nbsp;&nbsp;Height referenced above sea level, or zero elevation.</p>

<p>The K factor accounts for refraction of radio waves close to the surface of the earth.&nbsp;&nbsp;For antenna towers less than a couple of thousand feet above the surface, a K factor of 1.33 is usually adequate for most line-of-sight calculations over average terrain.</p>

<b><u>Typical Values of K</u></b>

<font face="">
<pre>
                                        Summer  Winter

Dry mountains (above 1500 meters)       1.20    1.20
Mountains (to 1500 meters)              1.25    1.25
Midwest and Northeast                   1.50    1.30
South and West Coast                    1.55    1.35
Southern Coast                          1.60    1.50
</pre>
</font>
</blockquote>

</body>
</html>
EOF
