#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Wireless Network Link Analysis, wireless.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/link_view.png";
my $cli_pic = "pics/gbppr-usa-climate.jpg";
my $tmp_pic = "pics/gbppr-usa-temp.jpg";
my $form = "./wireless.cgi";

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Wireless Network Link Analysis</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center><font face="Verdana, Arial, Helvetica"><h2>Wireless Network Link Analysis</h2></font></center>

<center><p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p></center>

<hr noshade>
<center><img src="$pic" alt="[link view]"></center>
<hr noshade>

<center>
<br><br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmitter Side Specifications</b></font></td>
</tr>
</table>
<br><br>
</center>

<form action="$form" method="post">
<table border="0">
<tr>
<td><b>Enter the highest transmitted frequency&nbsp;&nbsp;</b>
<input type="text" name="frq" size="10" value="2483">
<select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the transmitter's RF power output&nbsp;&nbsp;</b>
<input type="text" name="pwr_out" size="7" value="20">
<select name="pwr_out_val">
<option selected>dBm</option>
<option>milliwatts</option>
<option>watts</option>
<option>dBW</option>
<option>kilowatts</option>
<option>dBk</option>
</select></td>
</tr>
</table>

<center>
<br><br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmitter Side Cable &amp; Antenna Specifications</b></font></td>
</tr>
</table>
<br><br>
</center>

<table border="0">
<tr>
<td><b>Enter the transmitter's site name&nbsp;&nbsp;</b>
<input type="text" name="tx_name" size="30" value="TX Site"></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Choose the transmitter's external cable type&nbsp;&nbsp;</b>
<select name="tx_cab">
<option selected>Times Microwave LMR-400</option>
<option>Times Microwave LMR-400 UltraFlex</option>
<option>Times Microwave LMR-500</option>
<option>Times Microwave LMR-600</option>
<option>Times Microwave LMR-900</option>
<option>Times Microwave LMR-1200</option>
<option>Times Microwave LMR-1700</option>
<option>Andrew Heliax LDF4-50A</option>
<option>Andrew Heliax LDF5-50A</option>
<option>Andrew Heliax LDF6-50A</option>
<option>Andrew Heliax LDF7-50A</option>
<option>Belden 9913 (RG-8)</option>
<option>Belden 8267 (RG-213)</option>
<option>Belden 9258 (RG-8X)</option>
<option>Belden 8240 (RG-58)</option>
<option>Crap RG-8</option>
<option>Other</option>
</select></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>If </b>Other<b>, enter the transmitter's cable loss specification&nbsp;&nbsp;</b>
<input type="text" name="tx_cab_other" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<input type="radio" name="chia1" value="meters">&nbsp;per 100 meters&nbsp;&nbsp;
<input type="radio" name="chia1" value="feet" checked>&nbsp;per 100 feet</dd>
</dt>
</table>

<table border="0">
<tr>
<td><b>Enter the transmitter's external cable length&nbsp;&nbsp;</b>
<input type="text" name="tx_len" size="7" value="15">
<select name="tx_len_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the transmitter's antenna peak gain&nbsp;&nbsp;</b>
<input type="text" name="tx_ant_gain" size="7" value="24">
<select name="tx_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter transmitter's antenna radome loss<sup>1</sup>&nbsp;&nbsp;</b>
<input type="text" name="tx_radome" size="7" value="0"> dB</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the transmitter's site ground elevation (AMSL)&nbsp;&nbsp;</b>
<input type="text" name="tx_elv" size="7" value="185">
<select name="tx_elv_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the transmitter's antenna center-of-radiation height (AGL)<sup>2</sup>&nbsp;&nbsp;</b>
<input type="text" name="tx_ant_ht" size="7" value="8">
<select name="tx_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Total number of transmitter cable connectors and/or adapters&nbsp;&nbsp;</b>
<input type="text" name="con_tx" size="7" value="2"></td>
</tr>
</table>


<table border="0">
<tr>
<td><b>Enter any miscellaneous transmitter cable losses&nbsp;&nbsp;</b>
<input type="text" name="tx_misc_cab_loss" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected>-- Examples --</option>
<option>2-port splitter, 3.5 dB loss</option>
<option>4-port splitter, 6.5 dB loss</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Right angle N adapter, 0.5 dB loss</option>
<option>DC injector, 0.2 dB loss</option>
<option>Isolator, 0.8 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>RF branching loss</option>
<option>Transmit only attenuator pad</option>
<option>Flex jumpers</option>
<option>Standby switches</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter any miscellaneous transmitter gains (after cable loss)&nbsp;&nbsp;</b>
<input type="text" name="tx_misc_gain" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected>-- Examples --</option>
<option>Tower top linear RF power amplifier, 20 dB gain</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter any miscellaneous transmitter path losses<sup>3</sup>&nbsp;&nbsp;</b>
<input type="text" name="tx_misc_loss" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected> -- Examples --</option>
<option>Tree absorption, 0.15-0.4 dB/meter @ 1 GHz</option>
<option>Tree absorption, 0.25-0.5 dB/meter @ 2.4 GHz</option>
<option>Tree absorption, 0.4-0.6 dB/meter @ 3.3 GHz</option>
<option>Tree absorption, 0.5-1.5 dB/meter @ 5.8 GHz</option>
<option>Tree absorption, 1.0-2.0 dB/meter @ 10 GHz</option>
<option>Slight antenna mis-alignment loss, 0.5 dB</option>
<option>Orthogonal (90&deg;) antenna polarization mismatch, 20 dB</option>
<option>75&deg; antenna polarization mismatch, 12 dB</option>
<option>60&deg; antenna polarization mismatch, 6 dB</option>
<option>45&deg; antenna polarization mismatch, 3 dB</option>
<option>30&deg; antenna polarization mismatch, 1.3 dB</option>
<option>15&deg; antenna polarization mismatch, 0.3 dB</option>
<option>Linear to circular antenna polarization mismatch, 3 dB</option>
<option>Knife edge diffraction</option>
</select></td>
</tr>
</table>

<center>
<br><br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Receiver Side Cable &amp; Antenna Specifications</b></font></td>
</tr>
</table>
<br><br>
</center>

<table border="0">
<tr>
<td><b>Enter the receiver's site name&nbsp;&nbsp;</b>
<input type="text" name="rx_name" size="30" value="RX Site"></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Choose the receiver's external cable type&nbsp;&nbsp;</b>
<select name="rx_cab">
<option selected>Times Microwave LMR-400</option>
<option>Times Microwave LMR-400 UltraFlex</option>
<option>Times Microwave LMR-500</option>
<option>Times Microwave LMR-600</option>
<option>Times Microwave LMR-900</option>
<option>Times Microwave LMR-1200</option>
<option>Times Microwave LMR-1700</option>
<option>Andrew Heliax LDF4-50A</option>
<option>Andrew Heliax LDF5-50A</option>
<option>Andrew Heliax LDF6-50A</option>
<option>Andrew Heliax LDF7-50A</option>
<option>Belden 9913 (RG-8)</option>
<option>Belden 8267 (RG-213)</option>
<option>Belden 9258 (RG-8X)</option>
<option>Belden 8240 (RG-58)</option>
<option>Crap RG-8</option>
<option>Other</option>
</select></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>If </b>Other<b>, enter the receiver's cable loss specification&nbsp;&nbsp;</b>
<input type="text" name="rx_cab_other" size="7" value="0">
dB&nbsp;&nbsp;&nbsp;&nbsp;
<input type="radio" name="chia2" value="meters">&nbsp;per 100 meters&nbsp;&nbsp;
<input type="radio" name="chia2" value="feet" checked>&nbsp;per 100 feet</dd>
</dt>
</table>

<table border="0">
<tr>
<td><b>Enter the receiver's external cable length&nbsp;&nbsp;</b>
<input type="text" name="rx_len" size="7" value="15">
<select name="rx_len_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the receiver's antenna peak gain&nbsp;&nbsp;</b>
<input type="text" name="rx_ant_gain" size="7" value="12">
<select name="rx_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter receiver's antenna radome loss<sup>1</sup>&nbsp;&nbsp;</b>
<input type="text" name="rx_radome" size="7" value="0"> dB</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the receiver's site ground elevation (AMSL)&nbsp;&nbsp;</b>
<input type="text" name="rx_elv" size="7" value="180">
<select name="rx_elv_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the receiver's antenna center-of-radiation height (AGL)<sup>2</sup>&nbsp;&nbsp;</b>
<input type="text" name="rx_ant_ht" size="7" value="15">
<select name="rx_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><em>The following four questions are for vertical space diversity systems only.</em></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>Enter receiver's vertical diversity antenna center-of-radiation height (AGL)<sup>2</sup>&nbsp;&nbsp;</b>
<input type="text" name="rx_div_ant_ht" size="7" value="0">
<select name="rx_div_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select></dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter the receiver's diversity antenna peak gain&nbsp;&nbsp;</b>
<input type="text" name="rx_div_ant_gain" size="7" value="12">
<select name="rx_div_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter the receiver's diversity antenna external cable length<sup>4</sup>&nbsp;&nbsp;</b>
<input type="text" name="rx_div_len" size="7" value="20">
<select name="rx_div_len_val">
<option selected>meters</option>
<option>feet</option>
</select></dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter any miscellaneous receiver diversity antenna losses&nbsp;&nbsp;</b>
<input type="text" name="rx_div_misc_cab_loss" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected> -- Examples --</option>
<option>Radome loss, 0.5 dB</option>
<option>Connector loss, 0.25 dB</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Right angle N adapter, 0.5 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>Flex jumpers</option>
</select></dd>
</dt>
</table>

<table border="0">
<tr>
<td><b>Total number of receiver cable connectors and/or adapters&nbsp;&nbsp;</b>
<input type="text" name="con_rx" size="7" value="2"></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter any miscellaneous receiver cable losses&nbsp;&nbsp;</b>
<input type="text" name="rx_misc_cab_loss" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected> -- Examples --</option>
<option>2-port splitter, 3.5 dB loss</option>
<option>4-port splitter, 6.5 dB loss</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Right angle N adapter, 0.5 dB loss</option>
<option>DC injector, 0.2 dB loss</option>
<option>Isolator, 0.8 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>RF branching loss</option>
<option>Flex jumpers</option>
<option>Standby switches</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter any miscellaneous receiver gains (before cable loss)&nbsp;&nbsp;</b>
<input type="text" name="rx_misc_gain" size="7" value="0"> dB&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected>-- Examples --</option>
<option>Tower top receive pre-amplifier, 17 dB gain</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the receiver's threshold (sensitivity)&nbsp;&nbsp;</b>
<input type="text" name="BER" size="7" value="-77">
<select name="BER_val">
<option selected>dBm</option>
<option>microvolts</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><em>The following three questions are for digital data systems only.</em></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>If known, enter the receiver's dispersive fade margin (DFM)<sup>5</sup>&nbsp;&nbsp;</b>
<input type="text" name="dfm" size="7" value="0">
dB</dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>If known, enter the receiver's external interference fade margin (EIFM)<sup>6</sup>&nbsp;&nbsp;</b>
<input type="text" name="eifm" size="7" value="0">
dB</dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>If known, enter the receiver's adjacent channel interference fade margin (AIFM)<sup>7</sup>&nbsp;&nbsp;</b>
<input type="text" name="aifm" size="7" value="0">
dB</dd>
</dt>
</table>

<center>
<br><br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmit/Receive Antenna Distance &amp; Environmental Specifications</b></font></td>
</tr>
</table>
<br><br>
</center>

<table border="0">
<tr>
<td><b>Would you like to calculate the climate factor</a>?&nbsp;&nbsp;</b>
<input type="radio" name="chia4" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia4" value="no" checked>No</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>If </b>No<b>, choose the <a href="$cli_pic">climate factor</a>&nbsp;&nbsp;</b>
<select name="climate">
<option>0.25 : Mountainous, very rough, very dry but non-reflective</option>
<option selected>1 : Average terrain, with some roughness</option>
<option>2 : Great lakes area</option>
<option>4 : Very smooth terrain, over water or flat desert, non-coastal</option>
<option>6 : Very smooth terrain, over water or flat desert, coastal</option>
</select></td>
</tr>
</table>

<table>
<tr>
<td><b>If </b>Yes<b>, answer the following two questions.</b></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>Enter the average terrain roughness (deviation of elevations)<sup>8</sup>&nbsp;&nbsp;
</b>
<input type="text" name="rough" size="7" value="15">
<select name="rough_val">
<option selected>meters</option>
<option>feet</option>
</select></dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Choose the local area humidity type&nbsp;&nbsp;</b>
<select name="rough_hum">
<option>Coastal, very humid areas</option>
<option>Non-coastal, humid areas</option>
<option selected>Average or temperate areas</option>
<option>Dry areas</option>
</select></dd>
</dt>
</table>


<table border="0">
<tr>
<td><b>Enter the <a href="$tmp_pic">average annual temperature</a>&nbsp;&nbsp;</b>
<input type="text" name="temp" size="7" value="8">
<select name="temp_val">
<option selected>celsius</option>
<option>fahrenheit</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Enter the estimated land usage factor<sup>9</sup></a>&nbsp;&nbsp;</b>
<input type="text" name="land" size="7" value="30"> percent</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Would you like to calculate the effective Earth radius, K factor?<sup>10</sup>&nbsp;&nbsp;</b>
<input type="radio" name="chia3" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia3" value="no" checked>No</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>If </b>No<b>, enter the effective Earth radius, K factor&nbsp;&nbsp;</b>
<input type="text" name="k" size="7" value="1.33">&nbsp;&nbsp;&nbsp;&nbsp;
<select name="null">
<option selected>-- Examples --</option>
<option>5/12 = 0.42</option>
<option>1/2 = 0.50</option>
<option>2/3 = 0.67</option>
<option>1.0</option>
<option>7/6 = 1.17</option>
<option>4/3 = 1.33</option>
<option>5/3 = 1.67</option>
<option>2.0</option>
<option>4.0</option>
</select></td>
</tr>
</table>

<table>
<tr>
<td><b>If </b>Yes<b>, answer the following two questions.</b></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>Enter the average annual relative humidity&nbsp;&nbsp;</b>
<input type="text" name="rh" size="7" value="50"> percent</dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter the average annual barometric pressure&nbsp;&nbsp;</b>
<input type="text" name="baro" size="7" value="30"> inches of mercury</dd>
</dt>
</table>

<table border="0">
<tr>
<td><b>Enter the <a href="pics/rain_rate.html">precipitation rate</a>&nbsp;&nbsp;</b>
<input type="text" name="rate" size="7" value="0"> mm/hour</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Select the N <sub>th</sub> Fresnel zone to calculate&nbsp;&nbsp;</b>
<select name="nth">
<option>0.3</option>
<option>0.4</option>
<option>0.5</option>
<option>0.7</option>
<option>0.8</option>
<option>0.9</option>
<option selected>1</option>
<option>2</option>
<option>3</option>
<option>4</option>
<option>5</option>
<option>6</option>
<option>7</option>
<option>8</option>
<option>9</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td><b>Would you like to calculate the path distance based on latitude &amp; longitude?&nbsp;&nbsp;</b>
<input type="radio" name="chia" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia" value="no" checked>No</td>
</tr>
</table>

<table border="0">
<tr>
<td><b>If </b>No<b>, enter the distance between antenna sites&nbsp;&nbsp;</b>
<input type="text" name="dist" size="7" value="2">
<select name="dist_val">
<option selected>kilometers</option>
<option>miles</option>
</select></td>
</tr>
</table>

<table>
<tr>
<td><b>If </b>Yes<b>, answer the following four questions.</b></td>
</tr>
</table>

<table border="0">
<dt>
<dd><b>Enter the transmitter site's latitude&nbsp;&nbsp;</b>
<input type="text" name="y1" size="12" value="">(Use decimal degrees, positive is north)</dd>
</dt>
</table>

<table border="0">
<dd><b>Enter the transmitter site's longitude&nbsp;&nbsp;</b>
<input type="text" name="x1" size="12" value="">(Use decimal degrees, negative is west)</dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter the receiver site's latitude&nbsp;&nbsp;</b>
<input type="text" name="y2" size="12" value="">(Use decimal degrees, positive is north)</dd>
</dt>
</table>

<table border="0">
<dt>
<dd><b>Enter the receiver site's longitude&nbsp;&nbsp;</b>
<input type="text" name="x2" size="12" value="">(Use decimal degrees, negative is west)</dd>
</dt>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">

<blockquote>
<p><b>AGL</b>&nbsp;&nbsp;Above Ground Level.&nbsp;&nbsp;Height above common ground to the midpoint of the radiating antenna.</p>

<p><b>AMSL</b>&nbsp;&nbsp;Above Mean Sea Level.&nbsp;&nbsp;Height referenced above sea level, or zero elevation.</p>

<p>This script is not frequency dependant, though the minimum frequency is 20 MHz and things get hairly above 40 GHz.</p>

<p>Assumes <tt>0.1 * sqrt(Frequency_in_GHz)</tt> dB loss for each coax connector or adapter.</p>

<p>Antenna polarization losses are estimated, real world examples vary greatly.</p>

<p>Some sources of interference are in-band signals originating from other systems, reflections, multipath and receiver front-end overload produced by adjacent transmitters, such as MMDS/MDS/radar etc.</p>

<p><b><u>Notes</u></b></p>

<p>[1]&nbsp;&nbsp;For sealed yagi antennas, radome loss is usually taken into account in the antenna's specified gain.</p>

<p>[2]&nbsp;&nbsp;Antenna height and diversity antenna height should be measured from the antenna's center-of-radiation, usually the midpoint of the antenna.</p>

<p>[3]&nbsp;&nbsp;Miscellaneous path losses are caused by ground reflections, atmospheric absorption, interference, rain/fog, billboards, vegetation, knife-edge diffraction, small farm animals, etc.</p>

<p>[4]&nbsp;&nbsp;Diversity antenna cable type is assumed the same as the main receiver's.</p>

<p>[5]&nbsp;&nbsp;Dispersive fade margin is provided by your radio's manufacturer, and is determined by the type of modulation, effectiveness of any equalization in the receive path, and the multipath signal's time delay.&nbsp;&nbsp;Dispersive fade margin characterizes the radio's robustness to dispersive (spectrum-distoring) fades.</p>

<p>[6]&nbsp;&nbsp;External interference fade margin is receiver threshold degradation due to interference from external systems.</p>

<p>[7]&nbsp;&nbsp;Adjacent channel interference fade margin accounts for receiver threshold degradation due to interference from adjacent channel transmitters in one's own system.</p>

<p>[8]&nbsp;&nbsp;Example standard deviation of the terrain elevations: 6 meters - for smooth and over-water terrain, 15 meters - for average terrain with some roughness, 43 meters - for mountainous or very rough terrain.</p>

<p>[9]&nbsp;&nbsp;Land usage factor is the percentage of the path area covered by buildings of any type.</p>

<p>[10]&nbsp;&nbsp;The K factor accounts for refraction of radio waves close to the surface of the earth.&nbsp;&nbsp;For antenna towers less than a couple of thousand feet above the surface, a K factor of 1.33 is usually adequate for most line-of-sight calculations over average terrain.</p>

<b><u>Typical Values of K</u></b>

<font face="">
<pre>
                                        Summer  Winter

Dry mountains (above 1500 meters)       1.20    1.20
Mountains (to 1500 meters)              1.25    1.25
Midwest and Northeast                   1.50    1.30
South and West Coast                    1.55    1.35
Southern Coast                          1.60    1.50
</pre>
</font>
</blockquote>

</body>
</html>
EOF
